/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.AbstractTableModel;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector;
    protected Vector columnIdentifiers;
    int numColumns;
    int numRows;

    public DefaultTableModel() {
        this((Vector)null, 0);
    }

    public DefaultTableModel(int n, int n2) {
        this(new Vector(n), n2);
    }

    public DefaultTableModel(Vector vector, int n) {
        if (vector != null) {
            this.numColumns = vector.size();
            this.columnIdentifiers = vector;
        } else {
            this.numColumns = 0;
            this.columnIdentifiers = new Vector();
        }
        this.dataVector = new Vector();
        this.numRows = 0;
        if (n != 0) {
            this.setNumRows(n);
        }
    }

    public DefaultTableModel(Object[] objectArray, int n) {
        this(DefaultTableModel.convertToVector(objectArray), n);
    }

    public DefaultTableModel(Vector vector, Vector vector2) {
        this((Vector)null, 0);
        this.setDataVector(vector, vector2);
    }

    public DefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
        this((Vector)null, 0);
        this.setDataVector(objectArray, objectArray2);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector vector, Vector vector2) {
        if (vector == null) {
            throw new IllegalArgumentException("setDataVector() - Null parameter");
        }
        if (vector2 != null) {
            this.columnIdentifiers = vector2;
        }
        this.dataVector = vector;
        this.numColumns = ((Vector)this.dataVector.elementAt(0)).size();
        this.newDataAvailable(null);
    }

    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        Vector vector = null;
        if (objectArray2 != null) {
            vector = DefaultTableModel.convertToVector(objectArray2);
        }
        this.setDataVector(DefaultTableModel.convertToVector(objectArray), vector);
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || this.dataVector.size() != this.numRows) {
            this.numRows = this.dataVector.size();
            tableModelEvent = new TableModelEvent(this, -1);
            this.setColumnIdentifiers(this.columnIdentifiers);
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        this.numRows = this.dataVector.size();
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.numRows - 1;
        }
        int n3 = n;
        while (n3 <= n2) {
            ((Vector)this.dataVector.elementAt(n3)).setSize(this.numColumns);
            ++n3;
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null) {
            throw new IllegalArgumentException("rowsRemoved() - null parameter");
        }
        this.numRows = this.dataVector.size();
        this.fireTableChanged(tableModelEvent);
    }

    public void setColumnIdentifiers(Vector vector) {
        if (vector != null) {
            this.columnIdentifiers = vector;
            this.numColumns = vector.size();
        } else {
            this.columnIdentifiers = new Vector();
            this.numColumns = 0;
        }
        this.fireTableStructureChanged();
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
    }

    /*
     * Unable to fully structure code
     */
    public void setNumRows(int var1_1) {
        if (var1_1 < 0 || var1_1 == this.numRows) {
            return;
        }
        var2_2 = this.numRows;
        if (var1_1 > this.numRows) ** GOTO lbl12
        this.numRows = var1_1;
        this.dataVector.setSize(this.numRows);
        this.rowsRemoved(new TableModelEvent(this, this.numRows, var2_2 - 1, -1, -1));
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = new Vector<E>(this.numColumns);
            this.dataVector.addElement(var3_3);
            ++this.numRows;
lbl12:
            // 2 sources

            ** while (this.numRows < var1_1)
        }
lbl13:
        // 1 sources

        this.newRowsAdded(new TableModelEvent(this, var2_2, this.numRows - 1, -1, 1));
    }

    public void addColumn(Object object) {
        this.addColumn(object, (Vector)null);
    }

    public void addColumn(Object object, Vector vector) {
        if (object == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        this.columnIdentifiers.addElement(object);
        ++this.numColumns;
        int n = 0;
        Enumeration enumeration = this.dataVector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = vector != null && n < vector.size() ? (Object)vector.elementAt(n) : null;
            ((Vector)enumeration.nextElement()).addElement(e);
            ++n;
        }
        this.fireTableChanged(null);
    }

    public void addColumn(Object object, Object[] objectArray) {
        if (object == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        this.columnIdentifiers.addElement(object);
        ++this.numColumns;
        int n = 0;
        Enumeration enumeration = this.dataVector.elements();
        while (enumeration.hasMoreElements()) {
            Object object2 = objectArray != null && n < objectArray.length ? objectArray[n] : null;
            ((Vector)enumeration.nextElement()).addElement(object2);
            ++n;
        }
        this.fireTableChanged(null);
    }

    public void addRow(Vector vector) {
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector(this.numColumns);
        }
        this.dataVector.addElement(vector);
        ++this.numRows;
        this.newRowsAdded(new TableModelEvent(this, this.numRows - 1, this.numRows - 1, -1, 1));
    }

    public void addRow(Object[] objectArray) {
        Vector vector = null;
        if (objectArray != null) {
            vector = DefaultTableModel.convertToVector(objectArray);
        }
        this.addRow(vector);
    }

    public void insertRow(int n, Vector vector) {
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector(this.numColumns);
        }
        vector2.setSize(this.numColumns);
        this.dataVector.insertElementAt(vector2, n);
        ++this.numRows;
        this.newRowsAdded(new TableModelEvent(this, n, this.numRows - 1, -1, 1));
    }

    public void insertRow(int n, Object[] objectArray) {
        Vector vector = null;
        if (objectArray != null) {
            vector = DefaultTableModel.convertToVector(objectArray);
        }
        this.insertRow(n, vector);
    }

    public void moveRow(int n, int n2, int n3) {
        if (n < 0 || n >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 >= this.numColumns) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n < n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n <= n3 && n3 <= n2) {
            return;
        }
        boolean bl = n3 < n;
        TableModelEvent tableModelEvent = null;
        tableModelEvent = bl ? new TableModelEvent(this, n3, n2) : new TableModelEvent(this, n, n3);
        int n4 = n;
        while (n4 <= n2) {
            Object e = this.dataVector.elementAt(n4);
            this.dataVector.removeElementAt(n4);
            this.dataVector.insertElementAt(e, n3);
            if (bl) {
                ++n3;
            }
            ++n4;
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void removeRow(int n) {
        this.dataVector.removeElementAt(n);
        --this.numRows;
        this.rowsRemoved(new TableModelEvent(this, n, this.numRows - 1, -1, -1));
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public String getColumnName(int n) {
        if (this.columnIdentifiers == null || this.columnIdentifiers.size() <= n) {
            return super.getColumnName(n);
        }
        Object e = this.columnIdentifiers.elementAt(n);
        if (e == null) {
            return super.getColumnName(n);
        }
        return e.toString();
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public Object getValueAt(int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        return vector.elementAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        Vector vector = (Vector)this.dataVector.elementAt(n);
        vector.setElementAt(object, n2);
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(objectArray[n]);
            ++n;
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] objectArray) {
        if (objectArray == null) {
            return new Vector();
        }
        Vector<Vector> vector = new Vector<Vector>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            vector.addElement(DefaultTableModel.convertToVector(objectArray[n]));
            ++n;
        }
        return vector;
    }
}

